# 🔧 cPanel Installation Guide - Shopify Integration

## 📋 Step-by-Step Fix for cPanel

Follow these steps **exactly** to get the Shopify integration working on your cPanel hosting.

---

## ✅ Step 1: Upload Files via File Manager

### 1.1 Open cPanel File Manager
- Log in to cPanel
- Click **File Manager**
- Navigate to your Laravel root directory (usually `public_html` or `www`)

### 1.2 Upload config/app.php
- Navigate to `config/` folder
- **Download the current `app.php` as backup**
- Upload the new `config/app.php` (the one I modified)
- **Overwrite** the existing file

### 1.3 Upload MarketingBot Extension
- Navigate to `app/Extensions/` folder
- Upload the entire `MarketingBot` folder
- Make sure it includes:
  - `System/` folder with all controllers, models, services
  - `resources/` folder with all views
  - `config/` folder

### 1.4 Upload Migration Files
- Navigate to `database/migrations/` folder
- Upload these 5 files:
  - `2025_11_20_200000_create_shopify_stores_table.php`
  - `2025_11_20_200001_create_shopify_products_table.php`
  - `2025_11_20_200002_create_shopify_orders_table.php`
  - `2025_11_20_200003_create_campaign_conversions_table.php`
  - `2025_11_20_200004_create_marketing_dashboard_settings_table.php`

---

## ✅ Step 2: Clear Cache (CRITICAL!)

### Option A: Using Terminal in cPanel

1. **Open Terminal**
   - In cPanel, find **Terminal** icon
   - Click to open

2. **Navigate to your Laravel directory**
   ```bash
   cd public_html
   ```
   (or `cd www` or wherever your Laravel app is)

3. **Run these commands one by one:**
   ```bash
   php artisan config:clear
   php artisan route:clear
   php artisan cache:clear
   php artisan view:clear
   ```

4. **Verify routes are registered:**
   ```bash
   php artisan route:list | grep shopify
   ```
   
   You should see output like:
   ```
   GET|HEAD  dashboard/user/marketing-bot/shopify/settings
   POST      dashboard/user/marketing-bot/shopify/connect
   ...
   ```

### Option B: Manual Cache Clear (No Terminal Access)

1. **In File Manager, navigate to:**
   - `bootstrap/cache/`

2. **Delete these files:**
   - `config.php`
   - `routes-v7.php` (or any routes-*.php)
   - `services.php`
   - `packages.php`

3. **Navigate to:**
   - `storage/framework/cache/`

4. **Delete all files inside** (but keep the folder)

5. **Navigate to:**
   - `storage/framework/views/`

6. **Delete all files inside** (but keep the folder)

---

## ✅ Step 3: Import Database Tables

### Option A: Using phpMyAdmin (Recommended)

1. **Open phpMyAdmin** from cPanel
2. **Select your database** (the one your Laravel app uses)
3. **Click "Import" tab**
4. **Choose file:** `shopify_integration.sql`
5. **Click "Go"**
6. **Wait for success message**

### Option B: Using Terminal

```bash
cd public_html
php artisan migrate
```

---

## ✅ Step 4: Set Correct File Permissions

### In File Manager:

1. **Select these folders:**
   - `storage/`
   - `bootstrap/cache/`

2. **Right-click → Change Permissions**
   - Set to: **755** (or 775 if 755 doesn't work)
   - Check "Recurse into subdirectories"
   - Click "Change Permissions"

3. **For files inside storage/:**
   - Set to: **644** (or 664 if needed)

---

## ✅ Step 5: Verify Installation

### Test These URLs:

1. **Main Dashboard:**
   ```
   https://yourdomain.com/dashboard
   ```
   ✅ Should work

2. **Marketing Bot Dashboard:**
   ```
   https://yourdomain.com/dashboard/user/marketing-bot
   ```
   ✅ Should work

3. **Shopify Settings:**
   ```
   https://yourdomain.com/dashboard/user/marketing-bot/shopify/settings
   ```
   ✅ Should work (this is what you want!)

---

## 🐛 Troubleshooting

### Still Getting 404?

#### Check 1: Verify config/app.php was uploaded
- Open File Manager
- Navigate to `config/app.php`
- Click "Edit"
- Search for: `MarketingBotServiceProvider`
- **Should find:** `App\Extensions\MarketingBot\System\MarketingBotServiceProvider::class,`
- If NOT found, the file didn't upload correctly!

#### Check 2: Verify files are in correct location
- Check: `app/Extensions/MarketingBot/System/MarketingBotServiceProvider.php` exists
- Check: `app/Extensions/MarketingBot/System/Http/Controllers/ShopifyController.php` exists
- If missing, re-upload!

#### Check 3: Clear cache again
- Delete all files in `bootstrap/cache/`
- Delete all files in `storage/framework/cache/`
- Try accessing the URL again

#### Check 4: Check .htaccess
- Make sure `public/.htaccess` exists
- Should contain Laravel's default rewrite rules

---

## 📊 Quick Checklist

Before asking for help, verify:

- [ ] Uploaded `config/app.php` with MarketingBotServiceProvider
- [ ] Uploaded entire `app/Extensions/MarketingBot/` folder
- [ ] Uploaded all 5 migration files
- [ ] Cleared cache (via Terminal OR manually)
- [ ] Imported SQL file OR ran migrations
- [ ] Set correct file permissions (755 for folders, 644 for files)
- [ ] Verified files are in correct locations

---

## 🆘 If Still Not Working

Run this command in Terminal and send me the output:

```bash
php artisan route:list | grep marketing-bot
```

Also check:
```bash
ls -la app/Extensions/MarketingBot/System/
```

Send me the output and I'll tell you exactly what's wrong! 😊

---

## ✅ Expected Result

After completing all steps, you should be able to:
1. Access Shopify settings page
2. Enter Shopify credentials
3. Connect your store
4. See analytics on dashboard

**Good luck!** 🚀
